@echo off
setlocal enabledelayedexpansion
cd /d "%~dp0"
title Marvel Rivals - Auto Launcher
color 0B

:: ===============================================================
::  DISABLE QUICK EDIT MODE (Prevents freezing on click)
:: ===============================================================
powershell.exe -NoProfile -ExecutionPolicy Bypass -Command "&{$p='[DllImport(\"kernel32.dll\")]public static extern bool SetConsoleMode(IntPtr h,uint m);[DllImport(\"kernel32.dll\")]public static extern bool GetConsoleMode(IntPtr h,out uint m);[DllImport(\"kernel32.dll\")]public static extern IntPtr GetStdHandle(int n);';$t=Add-Type -MemberDefinition $p -Name 'W' -PassThru;$h=$t::GetStdHandle(-10);$m=0;if($t::GetConsoleMode($h,[ref]$m)){$t::SetConsoleMode($h,$m -band -bnot 0x0040)}}" >nul 2>&1

:: ===============================================================
::  ADMINISTRATOR CHECK
:: ===============================================================
fltmc >nul 2>&1
if %errorLevel% neq 0 (
    echo.
    echo  [ERROR] ACCESS DENIED: Administrator rights are required!
    echo  Please right-click "Start.bat" and select "Run as Administrator".
    echo.
    pause
    exit /b 1
)

:: ===============================================================
::  CONFIGURATION
:: ===============================================================
set "ConfigFile=config.ini"
set "FdExe=bin\fd.exe"
set "RamMap=bin\RAMMap64.exe"
set "GameLauncherName=MarvelRivals_Launcher.exe"

:: Initialize variables
set "PlatformPath="
set "GamePath="

:: ===============================================================
::  LOAD CONFIG
:: ===============================================================
if exist "%ConfigFile%" (
    for /f "usebackq tokens=1,* delims==" %%A in ("%ConfigFile%") do (
        if "%%A"=="PlatformPath" set "PlatformPath=%%B"
        if "%%A"=="GamePath" set "GamePath=%%B"
    )
)

:: Clean quotes if any
if defined PlatformPath set "PlatformPath=!PlatformPath:"=!"
if defined GamePath set "GamePath=!GamePath:"=!"

:: ===============================================================
::  PLATFORM SELECTION (If not in config)
:: ===============================================================
if defined PlatformPath (
    if exist "!PlatformPath!" goto :CheckGamePath
)

:SelectPlatform
cls
echo ===============================================================
echo  SELECT LAUNCHER
echo ===============================================================
echo.
echo  1 - Steam
echo  2 - Epic Games
echo  3 - Loading Bay
echo.
set /p "Choice=Enter your choice (1-3): "

if "%Choice%"=="1" (
    set "LauncherName=steam.exe"
    set "DefaultLauncherPath=C:\Program Files (x86)\Steam\steam.exe"
    set "LauncherLabel=Steam"
) else if "%Choice%"=="2" (
    set "LauncherName=EpicGamesLauncher.exe"
    set "DefaultLauncherPath=C:\Program Files (x86)\Epic Games\Launcher\Portal\Binaries\Win64\EpicGamesLauncher.exe"
    set "LauncherLabel=Epic Games"
) else if "%Choice%"=="3" (
    set "LauncherName=LoadingBayLauncher.exe"
    set "DefaultLauncherPath=C:\Program Files\LoadingBay\LoadingBayLauncher.exe"
    set "LauncherLabel=Loading Bay"
) else (
    echo [ERROR] Invalid choice. Please try again.
    pause
    goto :SelectPlatform
)

:SelectLauncherMethod
cls
echo ===============================================================
echo  LAUNCHER PATH DETECTION METHOD (%LauncherLabel%)
echo ===============================================================
echo.
echo  1 - Auto-Search (All Drives)
echo  2 - Default (%DefaultLauncherPath%)
echo  3 - Manual Input
echo.
set /p "MethodChoice=Enter your choice (1-3): "

if "%MethodChoice%"=="1" goto :AutoSearchLauncher
if "%MethodChoice%"=="2" (
    set "PlatformPath=%DefaultLauncherPath%"
    goto :ValidateLauncher
)
if "%MethodChoice%"=="3" goto :ManualLauncherInput
goto :SelectLauncherMethod

:AutoSearchLauncher
echo.
echo [SEARCH] Automatically finding %LauncherName%... please wait...

if exist "%FdExe%" (
    set "SearchDrives="
    for /f "skip=1 delims=" %%A in ('wmic logicaldisk where "DriveType=3" get DeviceID 2^>nul') do (
        for %%B in (%%A) do set "SearchDrives=!SearchDrives! %%B\"
    )
    if not defined SearchDrives set "SearchDrives=C:\"
    
    pushd "bin"
    for /f "delims=" %%I in ('fd.exe -F -u --max-results 1 "%LauncherName%" !SearchDrives!') do (
        set "PlatformPath=%%I"
    )
    popd
)

if not defined PlatformPath (
    echo.
    echo [ERROR] Could not find %LauncherName% automatically.
    echo Please try Manual Input.
    pause
    goto :SelectLauncherMethod
)
goto :ValidateLauncher

:ManualLauncherInput
cls
echo ===============================================================
echo  MANUAL LAUNCHER PATH ENTRY
echo ===============================================================
echo.
echo  [EXAMPLE] CORRECT PATH:
echo  C:\Program Files (x86)\Steam\steam.exe
echo.
set /p "UserLauncherPath=Enter the FULL path to %LauncherName%: "

set "UserLauncherPath=!UserLauncherPath:"=!"
set "PlatformPath=!UserLauncherPath!"
goto :ValidateLauncher

:ValidateLauncher
if not exist "!PlatformPath!" (
    echo.
    echo [WARNING] The selected launcher was not found at:
    echo "!PlatformPath!"
    echo.
    echo Please verify your installation or select another option.
    pause
    set "PlatformPath="
    goto :SelectPlatform
)

:: ===============================================================
::  GAME PATH SEARCH (If not in config)
:: ===============================================================
:CheckGamePath
if defined GamePath (
    if exist "!GamePath!" goto :SaveConfig
)

echo.
echo ===============================================================
echo  GAME PATH DETECTION METHOD
echo ===============================================================
echo.
echo  1 - Auto-Search (All Drives)
echo  2 - Manual Input
echo.
set /p "DiscChoice=Enter your choice (1-2): "

if "%DiscChoice%"=="2" goto :ManualInput

:AutoSearch
echo.
echo [SEARCH] Automatically finding %GameLauncherName%... please wait...

if exist "%FdExe%" (
    set "SearchDrives="
    for /f "skip=1 delims=" %%A in ('wmic logicaldisk where "DriveType=3" get DeviceID 2^>nul') do (
        for %%B in (%%A) do set "SearchDrives=!SearchDrives! %%B\"
    )
    if not defined SearchDrives set "SearchDrives=C:\"
    
    pushd "bin"
    for /f "delims=" %%I in ('fd.exe -F -u --max-results 1 "%GameLauncherName%" !SearchDrives!') do (
        set "GamePath=%%I"
    )
    popd
)
goto :CheckFound

:ManualInput
cls
echo ===============================================================
echo  MANUAL PATH ENTRY
echo ===============================================================
echo.
echo  [EXAMPLE] CORRECT PATH:
echo  E:\Games\Steam\steamapps\common\MarvelRivals\MarvelRivals_Launcher.exe
echo.
echo  [WARNING] DO NOT ENTER A FOLDER PATH!
echo  WRONG: E:\Games\Steam\steamapps\common\MarvelRivals\
echo.
set /p "UserPath=Enter the FULL path to MarvelRivals_Launcher.exe: "

set "UserPath=!UserPath:"=!"

if not exist "!UserPath!" (
    echo.
    echo [ERROR] File not found: "!UserPath!"
    echo Please ensure you entered the correct full path including .exe
    pause
    goto :ManualInput
)

set "GamePath=!UserPath!"
goto :SaveConfig

:CheckFound

if not defined GamePath (
    echo.
    echo [ERROR] Could not find %GameLauncherName% automatically.
    echo Please ensure the game is installed and try again.
    pause
    exit /b 1
)

:: ===============================================================
::  SAVE CONFIG
:: ===============================================================
:SaveConfig
(
    echo PlatformPath=!PlatformPath!
    echo GamePath=!GamePath!
) > "%ConfigFile%"

:: ===============================================================
::  RAM CLEANUP
:: ===============================================================
if exist "%RamMap%" (
    echo.
    echo [INFO] Performing RAM Cleanup...
    pushd "bin"
    
    echo   - Emptying Working Sets...
    RAMMap64.exe -accepteula -ew >nul 2>&1
    
    echo   - Emptying System Working Sets...
    RAMMap64.exe -accepteula -es >nul 2>&1
    
    echo   - Emptying Modified Page List...
    RAMMap64.exe -accepteula -em >nul 2>&1
    
    echo   - Emptying Standby List...
    RAMMap64.exe -accepteula -et >nul 2>&1
    
    echo   - Emptying Priority 0 Standby List...
    RAMMap64.exe -accepteula -e0 >nul 2>&1
    
    popd
    echo [OK] RAM Optimized.
)

:: ===============================================================
::  LAUNCH SEQUENCE
:: ===============================================================
echo.
echo [INFO] Platform: "!PlatformPath!"
echo [INFO] Game:     "!GamePath!"
echo.

echo [LAUNCH] Starting Platform Launcher...
start "" "!PlatformPath!"

echo.
echo [INFO] Waiting 3 seconds for the launcher to initialize...
timeout /t 3 /nobreak >nul

for %%I in ("!GamePath!") do set "GameDir=%%~dpI"

echo [LAUNCH] Starting Marvel Rivals...
start "" /d "!GameDir!" "!GamePath!"

exit /b 0